# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2004 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
#
# @(#)59   1.27   src/csm/install/pkgdefs/Linux-RedHatEL-ES3.pm.perl, setup, csm_rameh, rameh_base 7/6/04 06:14:02

#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL-ES3.pm.perl

        Package Definition File:    RedHatEL 3

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptionns:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package RedHatELES3;

do "/opt/csm/install/pkgdefs/Linux.pm";

NodeUtils->messageFromCat(
                          'csmInstall.cat',
                          $::MSGMAPPATH,
                          'csminstall',
                          'V',
                          'IMsgLoading',
                          "/opt/csm/install/pkgdefs/Linux-RedHatEL-ES3.pm"
                          );

my $_server_ = 'MgmtServer';
my $_node_   = 'MgdNode';

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

    $::pkgdefs{DISTRO_NAME} = "Red Hat Enterprise Linux ES 3";
    $::pkgdefs{DISTRO_DISKLIST} = "1 2 3 4";       # TO BE REMOVED
    $::pkgdefs{DISTRO_RPMDIR}   = "RedHat/RPMS";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_filename         = the filename to search to identify the disk
                                          - supportsw shell wildcards.
                diskid_searchstring     = the string to search for in diskid_filename
                                          - supports perl regular expressions


=cut

#--------------------------------------------------------------------------------
{
    my $dd_ref = [
        {
         num               => '1',
         name              => $::pkgdefs{DISTRO_NAME},
         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '1',
                               arch => 'i386',
                               key  => '1065565780.808209',
                               rpm  => 'SRPMS/comps-3es-0.20031007.src.rpm',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-ES3-i386',
        },
        {
         num               => '2',
         name              => $::pkgdefs{DISTRO_NAME},
         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '2',
                               arch => 'i386',
                               key  => '1065565780.808209',
                               rpm  => '',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-ES3-i386',
        },
        {
         num  => '3',
         name => $::pkgdefs{DISTRO_NAME},

         #diskid_filename     => '.discinfo',
         #diskid_searchstring => '^3$',
         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '3',
                               arch => 'i386',
                               key  => '1065565780.808209',
                               rpm  => '',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-ES3-i386',
        },
        {
         num               => '4',
         name              => $::pkgdefs{DISTRO_NAME},
         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '4',
                               arch => 'i386',
                               key  => '1065565780.808209',
                               rpm  => '',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-ES3-i386',
        }
        ];

    $::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3	Service Pack disks defination

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $qu1_ref = [
        {
         num               => '1',
         name              => $::pkgdefs{DISTRO_NAME} . " QU1",
         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '1',
                               arch => 'i386',
                               key  => '1065565780.808209',
                               rpm  => 'RedHat/Updates/redhat-release-3ES*',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-ES3-QU1',
        },
        {
         num               => '2',
         name              => $::pkgdefs{DISTRO_NAME},
         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '2',
                               arch => 'i386',
                               key  => '1065565780.808209',
                               rpm  => '',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-ES3-QU1',
        },
        {
         num  => '3',
         name => $::pkgdefs{DISTRO_NAME},

         #diskid_filename     => '.discinfo',
         #diskid_searchstring => '^3$',
         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '3',
                               arch => 'i386',
                               key  => '1065565780.808209',
                               rpm  => '',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-ES3-QU1',
        },
        {
         num               => '4',
         name              => $::pkgdefs{DISTRO_NAME},
         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '4',
                               arch => 'i386',
                               key  => '1065565780.808209',
                               rpm  => '',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-ES3-QU1',
        }
        ];

    $::pkgdefs{sp_disks}{QU1} = $qu1_ref;
}

#--------------------------------------------------------------------------------

{
    my $qu2_ref = [
                   {
                    num               => '1',
                    name              => $::pkgdefs{DISTRO_NAME} . " QU2",
                    diskid_searchargs => {
                                    file => '.discinfo',
                                    num  => '1',
                                    arch => 'i386',
                                    key  => '1083794425.140447',
                                    rpm => 'SRPMS/comps-3ES-0.20040505.src.rpm',
                    },
                    diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
                    diskid_target => 'RedHatEL-ES3-QU2',
                   },
                   {
                    num               => '2',
                    name              => $::pkgdefs{DISTRO_NAME} . " QU2",
                    diskid_searchargs => {
                                          file => '.discinfo',
                                          num  => '2',
                                          key  => '1083794425.140447',
                                          arch => 'i386',
                                          rpm  => '',
                    },
                    diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
                    diskid_target => 'RedHatEL-ES3-QU2',
                   },
                   {
                    num               => '3',
                    name              => $::pkgdefs{DISTRO_NAME} . " QU2",
                    diskid_searchargs => {
                                          file => '.discinfo',
                                          num  => '3',
                                          key  => '1083794425.140447',
                                          arch => 'i386',
                                          rpm  => '',
                    },
                    diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
                    diskid_target => 'RedHatEL-ES3-QU2',
                   },
                   {
                    num               => '4',
                    name              => $::pkgdefs{DISTRO_NAME} . " QU2",
                    diskid_searchargs => {
                                          file => '.discinfo',
                                          num  => '4',
                                          key  => '1083794425.140447',
                                          arch => 'i386',
                                          rpm  => '',
                    },
                    diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
                    diskid_target => 'RedHatEL-ES3-QU2',
                   }
                   ];

    $::pkgdefs{sp_disks}{QU2} = $qu2_ref;
}

#--------------------------------------------------------------------------------

=head3	opensrc_prereqs - Open Source Prereqs to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $opr_ref;

    # defaults
    $opr_ref{$_server_}{$::csm_version} =
      ['tftp-hpa', 'IBMJava2-JRE-1.4.1', 'conserver', 'fping'];

    $opr_ref{$_node_}{$::csm_version} = ['autoupdate'];

    # exceptionns  - must follow the default assignments.
    $opr_ref{$_node_}{'1.2.0'} = [];

    $::pkgdefs{opensrc_prereqs} = $opr_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	rsct_packages - RSCT Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $rp_ref;

    # defaults
    $rp_ref{$_server_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic', 'rsct.core.cimrm'];

    $rp_ref{$_node_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic', 'rsct.core.cimrm'];

    # exceptionns  - must follow the default assignments.
    # none
    $rp_ref{$_node_}{'1.2.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
    $rp_ref{$_node_}{'1.3.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
    $rp_ref{$_node_}{'1.3.1'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
    $rp_ref{$_node_}{'1.3.2'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];

    $::pkgdefs{rsct_packages} = $rp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_packages - CSM Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cp_ref;

    # defaults
    $cp_ref{$_server_}{$::csm_version} =
      ['csm.core', 'csm.dsh', 'csm.server', 'csm.diagnostics', 'csm.gui.dcem'];

    $cp_ref{$_node_}{$::csm_version} =
      ['csm.core', 'csm.client', 'csm.diagnostics'];

    # exceptionns  - must follow the default assignments.
    $cp_ref{$_node_}{'1.2.0'} = ['csm.core', 'csm.client'];

    $::pkgdefs{csm_packages} = $cp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	director_packages - Director Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $dp_ref;

    # defaults
    $dp_ref{$_server_}{$::csm_version} =
      ['csm.director.agent', 'csm.director.server'];

    $dp_ref{$_node_}{$::csm_version} =
      ['csm.director.agent', 'csm.director.server'];

    # exceptionns  - must follow the default assignments.
    $dp_ref{$_node_}{'1.2.0'} = [];
    $dp_ref{$_node_}{'1.3.0'} = [];

    $::pkgdefs{director_packages} = $dp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	rsct_unpackages - RSCT Packages to uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $rup_ref;

    # defaults
    $rup_ref{$_server_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.core.cimrm'];

    $rup_ref{$_node_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.core.cimrm'];

    # exceptionns  - must follow the default assignments.
    # none
    $rup_ref{$_node_}{'1.2.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];
    $rup_ref{$_node_}{'1.3.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];
    $rup_ref{$_node_}{'1.3.1'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];
    $rup_ref{$_node_}{'1.3.2'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];

    $::pkgdefs{rsct_unpackages} = $rup_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_unpackages - CSM Packages to uninstall	

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cup_ref;

    # defaults
    $cup_ref{$_server_}{$::csm_version} =
      ['csm.dsh', 'csm.server', 'csm.diagnostics', 'csm.gui.dcem'];

    $cup_ref{$_node_}{$::csm_version} =
      ['csm.core', 'csm.diagnostics', 'csm.client'];

    # exceptionns  - must follow the default assignments.
    $cup_ref{$_node_}{'1.2.0'} = ['csm.core', 'csm.client'];

    $::pkgdefs{csm_unpackages} = $cup_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_uninstall_dirs - Directories to uninstall from the management server

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cuid_ref;

    # defaults
    $cuid_ref{$_server_}{$::csm_version} = ['/csminstall', '/cfmroot'];

    $cuid_ref{$_node_}{$::csm_version} = [];

    # exceptionns  - must follow the default assignments.
    # none

    $::pkgdefs{csm_uninstall_dirs} = $cuid_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_nouninstall_pkgs - Packages to NOT uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cnip_ref;

    # defaults
    $cnip_ref{$_server_}{$::csm_version} = ['csm.core'];

    $cnip_ref{$_node_}{$::csm_version} = [];

    # exceptionns  - must follow the default assignments.
    # none

    $::pkgdefs{csm_nouninstall_pkgs} = $cnip_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	os_prereqs - Operating System pre-requisites

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $ospr_ref;

    $ospr_ref{$_server_} = [
                            'syslinux-*', 'perl-5*',
                            'nfs-utils-*',,
                            'dhcp-3*',      'pdksh-*',
                            'rdist-6*',     'tcl-8.3*',
                            'expect-5.38*', 'XFree86-libs-data-4.3*',
                            'expat-*',      'XFree86-libs-4.3*',
                            'tk-8.3*',      'freetype-2.1*',
                            'compat-libstdc++-7*'
                            ];

    $ospr_ref{$_node_} = [
                          'perl-5*',           'nfs-utils-*',
                          'pdksh-*',           'rdist-6*',
                          'perl-DB_File-*'
                          ];

    $::pkgdefs{os_prereqs} = $ospr_ref{$::mgmt_type};
}

#--------------------------------------------------------------------------------

=head3	getmacs_Exec

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
    my $ge_ref = [
                  'usr/bin/grep', 'usr/sbin/ifconfig',
                  'usr/bin/sed',  'usr/bin/sleep',
                  'usr/bin/bash'
                  ];

    $::pkgdefs{getmacs_Exec} = $ge_ref;
}

#--------------------------------------------------------------------------------

=head3	getmacs_Lib

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
    my $gl_str = '/lib';

    $::pkgdefs{getmacs_Lib} = $gl_str;
}

#--------------------------------------------------------------------------------

=head3	getmacs_ReqLibs

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
    my $gr_ref = [
                  '/lib/ld-linux.so.2', '/lib/libc.so.6',
                  '/lib/libdl.so.2',    '/lib/libtermcap.so.2'
                  ];

    $::pkgdefs{getmacs_ReqLibs} = $gr_ref;
}

#--------------------------------------------------------------------------------

=head3	getmacs_DirStructure

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
    my $gd_ref = [
                  "bin",  "etc",      "linuxrc", "modules",
                  "proc", ".profile", "sbin",    "tmp",
                  "var"
                  ];

    $::pkgdefs{getmacs_DirStructure} = $gd_ref;
}

#--------------------------------------------------------------------------------

1;    # end
